# Generated by Django 2.2 on 2019-04-25 01:13

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('location', models.CharField(max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='DAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accountNumber', models.CharField(max_length=20)),
                ('balance', models.FloatField()),
                ('amountWithdrawable', models.FloatField()),
                ('freeWithdrawalBalance', models.FloatField()),
                ('lockUpPeriod', models.IntegerField()),
                ('isUnlocked', models.BooleanField()),
                ('status', models.CharField(choices=[('LOCKED', 'LCK'), ('INACTIVE', 'INA'), ('ACTIVE', 'ACT')], default='LOCKED', max_length=3)),
                ('accountType', models.CharField(choices=[('CORE_ACCOUNT', 'CORE'), ('SAVINGS_PLAN', 'SAVINGS')], max_length=8)),
                ('dateCreated', models.DateField()),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.Branch')),
            ],
            options={
                'ordering': ('accountNumber',),
            },
        ),
        migrations.CreateModel(
            name='DAccountHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history', to='api.DAccount')),
            ],
        ),
        migrations.CreateModel(
            name='DCardHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=500)),
                ('dateCreated', models.DateField()),
            ],
        ),
        migrations.CreateModel(
            name='DTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='FundSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sourceType', models.CharField(choices=[('EXTERNAL_BANK', 'EB'), ('CARD_TRANSFER', 'CT'), ('PERSONAL_DEPOSIT', 'PD')], default='PERSONAL_DEPOSIT', max_length=3)),
            ],
        ),
        migrations.CreateModel(
            name='InterestScheme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('interestRate', models.FloatField()),
                ('interestType', models.CharField(choices=[('SIMPLE_INTEREST', 'SI'), ('COMPOUND_INTEREST', 'CI')], max_length=1)),
                ('frequency', models.CharField(choices=[('DAILY', 'DA'), ('WEEKLY', 'WE'), ('MONTHLY', 'MON'), ('YEARLY', 'YE')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='ReportScheme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('accountId', models.BooleanField()),
                ('accountType', models.BooleanField()),
                ('planType', models.BooleanField()),
                ('accountHolderName', models.BooleanField()),
                ('transactions', models.BooleanField()),
                ('currentBalance', models.BooleanField()),
                ('interestScheme', models.BooleanField()),
                ('aim', models.BooleanField()),
                ('genFrequency', models.CharField(choices=[('DAILY', 'DA'), ('WEEKLY', 'WE'), ('MON', 'MON'), ('QUATERLY', 'QUA'), ('SEMIANUM', 'SEM'), ('YEARLY', 'YEA')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='RewardScheme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('rewardType', models.CharField(choices=[('REFERRALS', 'REF'), ('BONUS', 'BON')], max_length=1)),
                ('methodOfCalc', models.CharField(choices=[('NOTAPPLY', 'NO'), ('ASSIGN', 'AS'), ('REFERAL', 'RE')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='UserInfo',
            fields=[
                ('firstName', models.CharField(max_length=100)),
                ('lastName', models.CharField(max_length=100)),
                ('otherName', models.CharField(max_length=100)),
                ('dateOfBirth', models.DateField()),
                ('gender', models.CharField(choices=[('MALE', 'M'), ('FEMALE', 'F'), ('OTHER', '0')], max_length=1)),
                ('email', models.CharField(max_length=100)),
                ('mobilePhone', models.CharField(max_length=100)),
                ('photoUrl', models.CharField(max_length=500)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='WithdrawalScheme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('totalAllowedWithdrawals', models.IntegerField()),
                ('numOfWithdrawals', models.IntegerField()),
                ('allowedDates', models.CharField(max_length=500)),
                ('penaltyRate', models.FloatField()),
                ('maxAmountAllowed', models.FloatField()),
                ('lastWithdrawal', models.DateField()),
                ('emergencyAllowedWithdrawals', models.IntegerField()),
                ('customWithdrawalInterval', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('homePhone', models.CharField(max_length=100)),
                ('emergencyPhone', models.CharField(max_length=100)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='api.UserInfo')),
                ('rewardScheme', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.RewardScheme')),
            ],
        ),
        migrations.CreateModel(
            name='DAccountTransConfirmation',
            fields=[
                ('initiatedTime', models.DateField()),
                ('abortionTime', models.DateField()),
                ('isConfirmed', models.BooleanField()),
                ('transaction', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='confirmation', serialize=False, to='api.DTransaction')),
            ],
        ),
        migrations.CreateModel(
            name='DAccountTransVerification',
            fields=[
                ('message', models.CharField(max_length=500)),
                ('isVerified', models.BooleanField()),
                ('transaction', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='verification', serialize=False, to='api.DTransaction')),
            ],
        ),
        migrations.CreateModel(
            name='SavingsScheme',
            fields=[
                ('name', models.CharField(max_length=100)),
                ('miniPrincipal', models.FloatField()),
                ('minLumpsum', models.FloatField()),
                ('savingsType', models.CharField(choices=[('SMART_SAVE', 'SMART'), ('SELECT_SAVE', 'SELECT'), ('SECURE_SAVE', 'SECURE'), ('KID_SAVE', 'KID')], max_length=8)),
                ('savingsFrequency', models.CharField(choices=[('DAILY', 'D'), ('WEEKLY', 'W'), ('MONTHLY', 'M')], max_length=1)),
                ('allowSwiftSave', models.BooleanField()),
                ('allowESave', models.BooleanField()),
                ('allowMultiple', models.BooleanField()),
                ('allowInterest', models.BooleanField()),
                ('minimumInvestPeriod', models.IntegerField()),
                ('interestCalScheme', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='api.InterestScheme')),
            ],
        ),
        migrations.CreateModel(
            name='UAccount',
            fields=[
                ('phone', models.CharField(max_length=20)),
                ('uAccountType', models.CharField(choices=[('EMPLOYEE', 'EM'), ('CUSTOMER', 'CU'), ('REGULAR', 'RE')], default='REGULAR', max_length=8)),
                ('allowOTP', models.BooleanField()),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='uaccount', serialize=False, to='api.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='UserHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actionDate', models.DateField()),
                ('actionPerformed', models.CharField(max_length=300)),
                ('actionDescription', models.CharField(max_length=500)),
                ('platform', models.CharField(max_length=100)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history', to='api.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='UserDocument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('nameHash', models.CharField(max_length=500)),
                ('purpose', models.CharField(max_length=300)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='TransferHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=500)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transferHistory', to='api.DAccountHistory')),
            ],
        ),
        migrations.CreateModel(
            name='InterestHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=500)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='interestHistory', to='api.DAccountHistory')),
            ],
        ),
        migrations.CreateModel(
            name='ExternalBank',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accountName', models.CharField(max_length=100)),
                ('accountNumber', models.CharField(max_length=20)),
                ('accountType', models.CharField(max_length=100)),
                ('allowedUSSDTRans', models.BooleanField()),
                ('allowedPhoneTrans', models.BooleanField()),
                ('bankName', models.CharField(max_length=100)),
                ('bankId', models.CharField(max_length=100)),
                ('fund', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='bank', to='api.FundSource')),
            ],
        ),
        migrations.CreateModel(
            name='DebitHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=500)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='debitHistory', to='api.DAccountHistory')),
            ],
        ),
        migrations.AddField(
            model_name='daccount',
            name='reportScheme',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.ReportScheme'),
        ),
        migrations.AddField(
            model_name='daccount',
            name='withdrawalScheme',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.WithdrawalScheme'),
        ),
        migrations.CreateModel(
            name='CreditHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.CharField(max_length=500)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='creditHistory', to='api.DAccountHistory')),
            ],
        ),
        migrations.CreateModel(
            name='Agreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('isSign', models.BooleanField()),
                ('signature', models.CharField(max_length=300)),
                ('message', models.CharField(max_length=500)),
                ('date', models.DateField(default=datetime.date.today)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='agreement', to='api.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('apartment', models.CharField(max_length=200)),
                ('street', models.CharField(max_length=100)),
                ('city', models.CharField(max_length=100)),
                ('state', models.CharField(max_length=100)),
                ('country', models.CharField(max_length=100)),
                ('postCode', models.CharField(max_length=100)),
                ('zipCode', models.CharField(max_length=100)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.UserInfo')),
            ],
        ),
        migrations.CreateModel(
            name='Transfer',
            fields=[
                ('amount', models.FloatField()),
                ('transaction', models.OneToOneField(blank=True, on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='transfer', serialize=False, to='api.DTransaction')),
                ('creditAccount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='creditAccount', to='api.DAccount')),
                ('debitAccount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='debitAccount', to='api.DAccount')),
            ],
        ),
        migrations.CreateModel(
            name='SavingsPlan',
            fields=[
                ('account', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='api.DAccount')),
                ('interestAccred', models.FloatField()),
                ('lumpSum', models.FloatField()),
                ('savingsScheme', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='plan', to='api.SavingsScheme')),
            ],
        ),
        migrations.AddField(
            model_name='fundsource',
            name='fundSource',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fundSource', to='api.SavingsPlan'),
        ),
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('workId', models.CharField(max_length=20)),
                ('type', models.CharField(max_length=20)),
                ('employedDate', models.DateField()),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='api.UserInfo')),
                ('branch', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='branch', to='api.Branch')),
            ],
        ),
        migrations.AddField(
            model_name='dtransaction',
            name='initiator',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='transaction', to='api.Employee'),
        ),
        migrations.CreateModel(
            name='Debit',
            fields=[
                ('amount', models.FloatField()),
                ('transaction', models.OneToOneField(blank=True, on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='debit', serialize=False, to='api.DTransaction')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.DAccount')),
            ],
        ),
        migrations.CreateModel(
            name='DAccountCard',
            fields=[
                ('cardType', models.CharField(choices=[('DIAMOND', 'DI'), ('GOLD', 'GO'), ('BRONZE', 'BR')], max_length=3)),
                ('lastUsed', models.DateField()),
                ('linkedAccount', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='account', serialize=False, to='api.DAccount')),
                ('accountHolder', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='card', to='api.Customer')),
                ('history', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='card', to='api.DCardHistory')),
                ('transaction', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='card', to='api.DTransaction')),
            ],
        ),
        migrations.AddField(
            model_name='daccount',
            name='accountHolder',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.Customer'),
        ),
        migrations.AddField(
            model_name='daccount',
            name='creator',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.Employee'),
        ),
        migrations.CreateModel(
            name='Credit',
            fields=[
                ('amount', models.FloatField()),
                ('transaction', models.OneToOneField(blank=True, on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='credit', serialize=False, to='api.DTransaction')),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='api.DAccount')),
            ],
        ),
        migrations.AddField(
            model_name='branch',
            name='manager',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='manager_branch', to='api.Employee'),
        ),
        migrations.CreateModel(
            name='Aim',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('targetDate', models.DateField()),
                ('calculatedAmount', models.FloatField()),
                ('savingsFreq', models.CharField(choices=[('DAILY', 'DA'), ('WEEKLY', 'WE'), ('MONTHLY', 'MO'), ('YEARLY', 'YE')], max_length=3)),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='aim', to='api.SavingsPlan')),
            ],
        ),
    ]
