from rest_framework.schemas import get_schema_view
from . import views
from django.urls import path, include 
from rest_framework import routers


schema_view = get_schema_view(title='DigiSaver API V1')

    
router = routers.DefaultRouter()
router.register('agreements', views.AgreementViewSet)
router.register('user-info', views.UserInfoViewSet)
router.register('user-history', views.UserHistoryViewSet)
router.register('user-doc', views.UserDocumentViewSet)
router.register('user-account', views.UAccountViewSet)
router.register('branch', views.BranchViewSet)
router.register('employee', views.EmployeeViewSet)
router.register('withdrawal-scheme', views.WithdrawalSchemeViewSet)
router.register('report-scheme', views.ReportSchemeViewSet)
router.register('reward-scheme', views.RewardSchemeViewSet)
router.register('interest-scheme', views.InterestSchemeViewSet)
router.register('savings-scheme', views.SavingsSchemeViewSet)
router.register('customer', views.CustomerViewSet)
router.register('digisaver-account', views.DAccountViewSet)
router.register('interest-history', views.InterestHistoryViewSet)
router.register('transfer-history', views.TransferHistoryViewSet)
router.register('debit-history', views.DebitHistoryViewSet)
router.register('credit-history', views.CreditHistoryViewSet)
router.register('account-history', views.DAccountHistoryViewSet)
router.register('confirmations', views. DAccountTransConfirmationViewSet)
router.register('verifications', views.DAccountTransVerificationViewSet)
router.register('credits', views.CreditViewSet)
router.register('debits', views.DebitViewSet)
router.register('transfers', views.TransferViewSet)
router.register('transactions', views.DTransactionViewSet)
router.register('card-history', views.DCardHistoryViewSet)
router.register('cards', views.DAccountCardViewSet)
router.register('savings-plans', views.SavingsPlanViewSet)
router.register('fund-sources', views.FundSourceViewSet)



urlpatterns = [
    path('', include(router.urls)),
    path('schema/', schema_view)
]
