from django.db import models
from django.conf import settings
from datetime import date
from api.models.branch_model import *

class Employee(models.Model):
    workId = models.CharField(max_length=20)
    type = models.CharField(max_length=20)
    employedDate = models.DateField()
    #RELATIONS
    user = models.OneToOneField(
        settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
        primary_key=True,
    )
    branch = models.ForeignKey(Branch, related_name="branch", on_delete = models.PROTECT)

