
from django.db import models
from api.models.savings_plan import FundSource

class ExternalBank(models.Model):
    accountName= models.CharField(max_length=100)
    accountNumber = models.CharField(max_length=20)
    accountType = models.CharField(max_length=100)
    allowedUSSDTRans = models.BooleanField()
    allowedPhoneTrans = models.BooleanField()
    bankName = models.CharField(max_length = 100)
    bankId = models.CharField(max_length = 100)
    # RELATIONS
    fund = models.OneToOneField(
        FundSource,
        on_delete=models.CASCADE,
        blank = True,
        null = True, 
        related_name = 'bank'
    )