from django.db import models
from api.models.interest_scheme import *


class SavingsScheme(models.Model):
    SAVINGS_TYPE = (("SMART_SAVE", "SMART"), ("SELECT_SAVE", "SELECT"),
                    ("SECURE_SAVE", "SECURE"), ("KID_SAVE", "KID"))

    SAVINGS_FREQUENCY = (("DAILY", "D"), ("WEEKLY", "W"), ("MONTHLY", "M"))

    name = models.CharField(max_length=100)
    miniPrincipal = models.FloatField()
    minLumpsum = models.FloatField()
    savingsType = models.CharField(max_length=8, choices=SAVINGS_TYPE)
    savingsFrequency = models.CharField(
        max_length=1, choices=SAVINGS_FREQUENCY)
    allowSwiftSave = models.BooleanField()
    allowESave = models.BooleanField()
    allowMultiple = models.BooleanField()
    allowInterest = models.BooleanField()
    minimumInvestPeriod = models.IntegerField()
    #RELATIONS
    interestCalScheme = models.OneToOneField(
        InterestScheme,
        on_delete=models.CASCADE,
        primary_key=True,
    )

