"""src URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include 
from rest_framework import routers
from rest_framework.schemas import get_schema_view



schema_view = get_schema_view(title='DigiSaver Main')


urlpatterns = [
    # path('api/',include('api.urls')),
    # path('api-auth/',include('rest_framework.urls', namespace = 'rest_framework')),
    path('admin/', admin.site.urls),
    path('schema/', schema_view),
    # path('api/oauth/', include('oauth2_provider.urls', namespace='oauth2_provider')),
    path('api/account/', include('users.urls')),
]
