from django.contrib.auth.base_user import BaseUserManager
from django.utils.translation import ugettext_lazy as _
from django.db import transaction

from django.db import transaction



class CustomUserManager(BaseUserManager):
    """
    Custom user model manager where email is the unique identifiers
    for authentication instead of usernames.
    """
    @transaction.atomic
    def create_user(self, email, password, **extra_fields):
        """
        Create and save a User with the given email and password.
        """ 
        email = self.normalize_email(email)
        user = self.model(email=email, **extra_fields)
        user.set_password(password)
        print(user)
        return
        if CustomUser.objects.get(phone=user.phone) is None:
            if not email:
                raise ValueError(_('The Email must be set'))
            user.save()
            return user
        else:
            user.delete()
            raise ValueError(_('The phone number is already registered with an account'))

    def create_superuser(self, email, password, **extra_fields):
        """
        Create and save a SuperUser with the given email and password.
        """
        extra_fields.setdefault('is_staff', True)
        extra_fields.setdefault('is_superuser', True)
        extra_fields.setdefault('is_active', True)

        if extra_fields.get('is_staff') is not True:
            raise ValueError(_('Superuser must have is_staff=True.'))
        if extra_fields.get('is_superuser') is not True:
            raise ValueError(_('Superuser must have is_superuser=True.'))
        return self.create_user(email, password, **extra_fields)