from django.contrib import admin
from django.urls import path, include 
from rest_framework import routers
from . import views
from rest_framework.schemas import get_schema_view
from rest_auth.registration.views import (
    SocialAccountListView, SocialAccountDisconnectView
)
from rest_framework_jwt.views import obtain_jwt_token
from rest_framework_jwt.views import refresh_jwt_token
from rest_framework_jwt.views import verify_jwt_token

schema_view = get_schema_view(title='Authentication')

router = routers.DefaultRouter()
router.register('users', views.UserViewSet)
router.register('groups', views.GroupViewSet)

urlpatterns = [
    path('', include(router.urls)),
    path('user-exist', views.user_exist),
    path('auth/', include('rest_auth.urls')),
    path('auth/registration/', include('rest_auth.registration.urls')),
    path('auth/token/', obtain_jwt_token),
    path('auth/token/refresh/', refresh_jwt_token),
    path('auth/token/verify/', verify_jwt_token),
    path('auth/facebook/', views.FacebookLogin.as_view(), name='fb_login'),
    path('auth/twitter/', views.TwitterLogin.as_view(), name='twitter_login'),
    path('auth/facebook/connect/', views.FacebookConnect.as_view(), name='fb_connect'),
    path('auth/twitter/connect/', views.TwitterConnect.as_view(), name='twitter_connect'),
    path('socialaccounts/', SocialAccountListView.as_view(), name='social_account_list'),
    path('socialaccounts/<pk>/disconnect/', SocialAccountDisconnectView.as_view(),name='social_account_disconnect'),
    path('schema/', schema_view)
]