from models.configs.dbconfig import db, ma
from sqlalchemy import exc


class ChannelModel(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    channel_id = db.Column(db.String(50), unique = True)
    channel_name = db.Column(db.String(50))
    description = db.Column(db.String(500))
    uid = db.Column(db.String(50))
    users = db.Column(db.Text())
    date_added = db.Column(db.String(50))
    updated_on = db.Column(db.String(50))
    image = db.Column(db.String(50))
    chat_history = db.relationship('MessagesModel', backref="channel_model", uselist=False)


class MessagesModel(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    channel_id = db.Column(db.String(50), db.ForeignKey('channel_model.channel_id'), unique = True)
    messages = db.Column(db.Text())

class ChannelModelSchema(ma.Schema):
    class Meta:
        fields = ('channel_id', 'channel_name', 'uid', 'users', 'date_added')

class MessagesModelSchema(ma.Schema):
    class Meta:
        fields = ('channel_id', 'messages')

channel_model_scheme = ChannelModelSchema()
channel_models_scheme = ChannelModelSchema(many = True)

messages_model_scheme = MessagesModelSchema()
messages_models_scheme = MessagesModelSchema(many = True)


db.create_all()