from models.configs.core import make_response, request, app, jsonify, InvalidUsage
import jwt
import datetime
from functools import wraps
from models.libs.api import curl

userInfo = ''

def validate_token(f):
    @wraps(f)
    def decorated(*args, **kwargs):
        auth = request.headers.get('Authorization')
        if not auth:
            return make_response({
                "error": "authorization required. access forbidden"
            }, 403)
        
        token = auth.split(' ')[1]
        
        if not token:
            return make_response({
                "error": "bad request. missing token"
            }, 400)

        try: 
            data = jwt.decode(token, app.config['SECRET_KEY'])
        except Exception as e:
            return make_response({
                "error": "Token is invalid " + str(e)
            }, 500)
        
        return f(*args, **kwargs)
    return decorated

def get_userinfo(userinfo):
    return curl({
        "url": f"{app.config['USER_URL']}users/{userinfo['uid']}",
        "method": "GET",
        "headers": {
            'Authorization': request.headers.get('Authorization')
        }
    }, "")

def decodejwt():
    auth = request.headers.get('Authorization')
    token = auth.split(' ')[1]
    userinfo = jwt.decode(token, app.config['SECRET_KEY'])['user']
    user = get_userinfo(userinfo)
    if user['message']['auth_id']:
        return {
            "user": user['message'],
        }
    else:
        raise Exception("user not found")