from models.configs.core import app, jsonify, InvalidUsage, Response, lru_cache
from controllers.messaging import Channels, Messaging
from models.libs.jwt import validate_token

@app.route('/chat', methods=['POST'])
@validate_token
def send_chat():
    try:
        return Messaging.save_and_send_chat_messages()
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/chat/<id>', methods=['DELETE'])
@validate_token
def delete_chat_message(id):
    try:
        return Messaging.delete_message(id)
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/channels', methods=['POST'])
@validate_token
def create_channel():
    try:
        return Channels.create_channel()
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/channels', methods=['GET'])
@validate_token
def get_channel():
    try:
        return Channels.get_all_channels()
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/channels/<channelid>', methods=['GET'])
@validate_token
def get_channel_messages(channelid):
    try:
        return Channels.get_all_channel_messages(channelid)
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/channels/<channelid>', methods=['PUT'])
@validate_token
def update_channel(channelid):
    try:
        return Channels.update_channel(channelid)
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)


@app.route('/channels/<channelid>', methods=['DELETE'])
@validate_token
def delete_channel(channelid):
    try:
        return Channels.delete_channel(channelid)
    except Exception as e:
        raise InvalidUsage(str(e), status_code=500)