from models.configs.core import *
from views.messaging_route import *

@app.errorhandler(InvalidUsage)
def handle_invalid_usage(error):
    response = jsonify(error.to_dict())
    response.status_code = error.status_code
    return response

@app.errorhandler(404)
def not_found(error):
    return make_response(jsonify({'error': 'url not found'}), 404)

@app.route('/', methods=['GET'])
def get():
    return jsonify({})
